//
//  URLLoader.m
//  Logo
//
//  Created by Jonathan Diehl on 02.03.11.
//  Copyright 2011 RWTH. All rights reserved.
//

#import "URLLoader.h"


@implementation URLLoader

@synthesize delegate;

// init
- (id)initWithRequest:(NSURLRequest *)aRequest;
{
	self = [super init];
	if (self != nil) {
		request = [aRequest retain];
	}
	return self;
}

// start the download
- (void)start;
{
	data = [[NSMutableData alloc] init];
	connection = [[NSURLConnection alloc] initWithRequest:request delegate:self];
	[connection start];
}

#pragma mark NSURLConnectionDelegate

// connection did load a chunk of data
- (void)connection:(NSURLConnection *)connection didReceiveData:(NSData *)newData
{
	[data appendData:newData];
}

// connection is done loading data
- (void)connectionDidFinishLoading:(NSURLConnection *)connection
{
	[self.delegate urlLoader:self didFinishLoadingData:[data copy]];
	[data release];
	data = nil;
}


#pragma mark Memory management

// cleanup
- (void) dealloc
{
	[connection cancel];
	[connection release];
	[request release];
	[data release];
	[super dealloc];
}


@end
